﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using Neurons;
using System.Xml.Serialization;  // Does XML serializing for a class.
namespace NNControl
{
    public partial class TrainingParametersForm : Form
    {
        Neurons.NetworkParameters parameters;
        public Neurons.NetworkParameters Parameters
        {
            get
            {
                return parameters;
            }
            set 
            {
                if (parameters == value)
                {
                    return;
                }
                else
                {
                    parameters = value;
                }
            }
           
        }
        public TrainingParametersForm()
        {
            InitializeComponent();
            parameters = null;
            initData();
        }
        void initData()
        {
            String filename = String.Format("{0}\\{1}", Environment.CurrentDirectory, "Config\\NetworkParameters.xml");
            LoadParameters(filename);
        }
        #region xml file
        private string CreateFileDoesNotExistMsg(String filename)
        {
            return "The example XML file '" + filename + "' does not exist." + "\n\n" +
            "To create the example XML file, enter customer details then click the 'Save' button.";
        }

        private string CreateHowToMsg(String filename)
        {
            return "To demonstrate saving of a 'Customer' object to an XML file ('"
                + filename + "'), enter the customer details then click the 'Save' button.";
        }
        #endregion
        public bool LoadParameters(String filename)
        {
            try
            {
                // Load the lockerz option from the existing XML file (if any)...
                if (File.Exists(filename) == true)
                {
                    // Load the customer object from the XML file using our custom class...
                    parameters = ObjectXMLSerializer<NetworkParameters>.Load(filename);

                    if (parameters == null)
                    {
                        MessageBox.Show("Unable to load trainingRate object from file '" + filename + "'!", Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
                        return false;
                    }
                    else  // Load trainingRate properties into the form...
                    {
                        udAfterNEpochs.Value = (int)parameters.DecayAfterEpochs;
                        tbTrainingRateDecay.Text = parameters.EtaDecay.ToString();
                        cbUseDistortions.Checked = parameters.Distorted;
                        tbElasticScaling.Text = parameters.ElasticScaling.ToString();
                        tbElasticSigma.Text = parameters.ElasticSigma.ToString();
                        udNumofEpochs.Value = (decimal)parameters.Epochs;
                        tbMaxRotation.Text = parameters.MaxRotation.ToString();
                        tbMaxScaling.Text = parameters.MaxScaling.ToString();
                        tbMinLearningRate.Text = parameters.MinimumEtaLearningRate.ToString();
                        tbInitialLearningRate.Text = parameters.InitialEtaLearningRate.ToString();
                        udSameDistortions.Value = (decimal)parameters.SameDistortionsForNEpochs;
                        tbSeverityFactor.Text = parameters.SeverityFactor.ToString();
                        tbWeightSaveErrorThreshold.Text = parameters.WeightSaveTreshold.ToString();
                        udDistotionEpochs.Value = (decimal)parameters.DistotionEpochs;
                        udNumHessianPatterns.Value = (decimal)parameters.NumHessianPatterns;
                        //MessageBox.Show("trainingRate loaded from file '" + filename + "'!", Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }
                    return true;
                }
                else
                {
                    MessageBox.Show(this.CreateFileDoesNotExistMsg(filename), Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return false;
                }
            }
            catch (Exception ex)
            {
                return false;
            }

        }
        public bool SaveParameters(String filename)
        {
            try
            {
                parameters = new NetworkParameters();
                parameters.DecayAfterEpochs = (int)udAfterNEpochs.Value;
                parameters.EtaDecay = Convert.ToDouble(tbTrainingRateDecay.Text);
                parameters.Distorted = cbUseDistortions.Checked;
                parameters.ElasticScaling = Convert.ToDouble(tbElasticScaling.Text);
                parameters.ElasticSigma = Convert.ToDouble(tbElasticSigma.Text);
                parameters.Epochs = Convert.ToInt32(udNumofEpochs.Value);
                parameters.MaxRotation = Convert.ToDouble(tbMaxRotation.Text);
                parameters.MaxScaling = Convert.ToDouble(tbMaxScaling.Text);
                parameters.MinimumEtaLearningRate = Convert.ToDouble(tbMinLearningRate.Text);
                parameters.InitialEtaLearningRate = Convert.ToDouble(tbInitialLearningRate.Text);
                parameters.SameDistortionsForNEpochs = Convert.ToInt32(udSameDistortions.Value);
                parameters.SeverityFactor = Convert.ToDouble(tbSeverityFactor.Text);
                parameters.WeightSaveTreshold = Convert.ToDouble((tbWeightSaveErrorThreshold.Text));
                parameters.DistotionEpochs = (int)udDistotionEpochs.Value;
                parameters.NumHessianPatterns = (uint)udNumHessianPatterns.Value;
                ObjectXMLSerializer<NetworkParameters>.Save(parameters, filename);
                //MessageBox.Show("trainingRate saved to XML file '" + filename + "'!", Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                return false;
            }
            return true;
        }

        private void btTrain_Click(object sender, EventArgs e)
        {
            String filename = String.Format("{0}\\{1}", Environment.CurrentDirectory, "Config\\NetworkParameters.xml");
            if (SaveParameters(filename))
            {
                this.DialogResult = DialogResult.OK;

            }
            else
            {
                this.DialogResult = DialogResult.Cancel;
            }
            this.Close();
        }
    }
}
